#!/bin/bash

if [ -x /bin/usleep ]; then
        SLEEP=/bin/usleep
        SLEEP_TIME=200000
elif [ -x /bin/sleep ]; then
        SLEEP=/bin/sleep
        SLEEP_TIME=1
else
        SLEEP=
        SLEEP_TIME=
fi

trap_hl()
{
 printf '\r'
 printf ' '
 printf '\n'
 exit 0
}

trap 'trap_hl' 2 9 15

if [ ! -z "$SLEEP" ]; then
        while true
        do
        	printf '\'
        	printf '\r' 
        	$SLEEP $SLEEP_TIME
        	printf '|'
        	printf '\r' 
        	$SLEEP $SLEEP_TIME
        	printf '/'
        	printf '\r' 
        	printf '-'
        	printf '\r' 
        	$SLEEP $SLEEP_TIME
        done
fi
